import java.io.*;
import javax.swing.*;
import javax.swing.filechooser.*;
import java.sql.*;

public class GUIUtil {

    static String fileSeparator = System.getProperty( "file.separator");
    public static String selectFile( ) {
	 return selectFile(null, JFileChooser.OPEN_DIALOG, "Text files", "txt");
    }

    public static String selectFile(int dialogType, String desc, String type ) {
	 return selectFile(null, dialogType, desc, type );
    }

    public static String selectFile( String dir, int dialogType, String desc, String type ) {

	if ( dir == null ) dir = System.getProperty("user.dir");

	JFileChooser chooser = new JFileChooser ( dir) ;
	FileNameExtensionFilter filter = new FileNameExtensionFilter(desc, type);
	chooser.setFileFilter(filter);
	int res ;
	
	switch ( dialogType ) {
		case JFileChooser.OPEN_DIALOG:
			res = chooser.showOpenDialog( null ); break;
		case JFileChooser.SAVE_DIALOG:
			res = chooser.showSaveDialog( null ); break;
		default:
			res = chooser.showOpenDialog( null ); break;
	}

	// If a file is selected, save the selected in member variable.
	if ( res == JFileChooser.APPROVE_OPTION)
		return chooser.getSelectedFile().getPath(); // Save CDF file  

	return null;
    }

    public static void fillComboBox( ResultSet res, JComboBox cbx ) {
	 fillComboBox( res, 1, cbx );
    }

    public static void fillComboBox( ResultSet res, int colNum, JComboBox cbx ) {
	try {
		while ( res.next() ) cbx.addItem( res.getString(colNum ) );
	} catch (SQLException e) { e.printStackTrace(); }
    }

    public static int yesNoConfirm ( JFrame parent, String title, String msg ) {
	 return JOptionPane.showConfirmDialog( parent, msg, title,
			 JOptionPane.YES_NO_OPTION, JOptionPane.INFORMATION_MESSAGE );
    }

}

