
import java.io.*;
import java.sql.*;
import java.text.*;
import java.io.*;
import javax.swing.*;
 
public class FileIO {
 
    static File file = null;

   public static int makeTextFile(ResultSet res, int currentRow, int numRows, boolean colSelected[] ) {
      int widthArr[] = null;
      ResultSetMetaData meta;
      try {
         String tmp = null;
         JFileChooser chooser = new JFileChooser();
         int returnValue = chooser.showSaveDialog( null );
         file = new File( chooser.getCurrentDirectory(), chooser.getSelectedFile().getName() );
         PrintStream out = new PrintStream( new FileOutputStream( file ) );
         meta = res.getMetaData();
         int colCnt = meta.getColumnCount();
         widthArr = getColumnWidths(colCnt, meta);
         for( int i = 0; i < numRows; i++ ) {
            res.relative( i - currentRow ); currentRow = i;
            for ( int j = 1; j <= colCnt; j++ ) {
               if( colSelected[j-1] ) {
                  tmp = res.getString( j ) ;    // get value at that column
                  if( tmp == null ) out.print(ScreenIO.expandString( " ", widthArr[j-1] + 1 )) ;
                  else out.print(ScreenIO.expandString( tmp, widthArr[j-1] + 1 )) ;
               }
            }
            out.println();
         }
         out.close();
      } catch (SQLException e) { e.printStackTrace();   }
         catch (NullPointerException e ) {}
         catch ( IOException e ) { System.out.println( e.toString() ); }
   return currentRow;
   }

   public static int makeLabelFile(ResultSet res, int currentRow, int rowCnt ) {
      int widthArr[] = null;
      ResultSetMetaData meta;
      try {
         String first, last, street, city, state, zip;
         JFileChooser chooser = new JFileChooser();
         int returnValue = chooser.showSaveDialog( null );
         file = new File( chooser.getCurrentDirectory(), chooser.getSelectedFile().getName() );
         PrintStream out = new PrintStream( new FileOutputStream( file ) );
         meta = res.getMetaData();
         int colCnt = meta.getColumnCount();
         widthArr = getColumnWidths(colCnt, meta);
         for( int i = 0; i < rowCnt; i++ ) {
            res.relative( i - currentRow ); currentRow = i;
            first = ( res.getString(3) == null )? " " : res.getString(3);
            last = ( res.getString(2) == null )? " " : res.getString(2);
            street = ( res.getString(9) == null )? " " : res.getString(9);
            city = ( res.getString(10) == null )? " " : res.getString(10);
            state = ( res.getString(11) == null )? " " : res.getString(11);
            zip = ( res.getString(12) == null )? " " : res.getString(12);
            out.println( first + " " + last );   // name
            out.println( street );   // address
            out.println( city + ", " + state + " " + zip );  // city, state zip
            out.println();
            out.println();
         }
         out.close();
      } catch (SQLException e) { e.printStackTrace();   }
         catch (NullPointerException e ) {}
         catch ( IOException e ) { System.out.println( e.toString() ); }
      return currentRow;
   }

   static int [] getColumnWidths(int colCnt, ResultSetMetaData meta) {
      int [] widthArr = new int[colCnt];
      for ( int i = 1; i <= colCnt; i ++ ) {
         try {
            widthArr[i-1] = meta.getColumnDisplaySize(i);
            switch( meta.getColumnType(i) ) {
               case Types.NUMERIC: widthArr[i-1] = 10; break;
               case Types.DECIMAL: widthArr[i-1] = 10; break;
               case Types.DATE: widthArr[i-1] = 10; break;
               case Types.TIME: widthArr[i-1] = 10; break;
               case Types.TIMESTAMP: widthArr[i-1] = 10; break;
            }
         } catch (SQLException e) {}
      }
      return widthArr;
   }
}

