/** GUI Addressbook with following features
 * 	 1. JTable is used to display several columns and addresses, and some text fields/area
 * 	    are used to display other columns.
 * 	 2. An resultset is used directly in the JTable's data model.
 * 	 3. A call to stored procedure to remove a records, and another call to stored function to
 * 	    a address ID for new address record.
 * 	 4. The connection to database is maintained for the life of the application. A disconnected
 * 	    record set and batch updata will be tried using array[][] of strings and status[][] to
 * 	    record the updaates to database, and batch update will carry out the changes to database.
 * 	    */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.JTextComponent;
import javax.swing.table.*;
import javax.swing.event.*;
import java.io.*;
import java.util.*;
import java.util.regex.*;
 
public class Addressbook extends JFrame implements ActionListener, ItemListener {

   GridBagConstraints gbConstraints  = new GridBagConstraints();

   static final int serialVersionUID = 1299999;
   static final int w_width = 930, w_height = 700;
   static final int n_cols = 13;
   static final int n_txtBoxes = 5; 
   static final int street_start = 7;
   		int curTblRow = 0;
   		int mdlRow = 0, mdlCol = 0;

   AddressTableModel addrTMDL = new AddressTableModel();
   JTable tbl = null;
   TableRowSorter<AddressTableModel> sorter;

   JScrollPane scrollPane = null;
   JButton btnAdd = new JButton("Add"), btnSave = new JButton("Save"),
           btnDelete = new JButton("Delete"), btnReload = new JButton("Reload");
   JPanel  pnButtons = new JPanel();
   JLabel  lbName    = new JLabel("Last, first name" ) ;
   Container c;

   private JMenuItem openItem;
   private JMenuItem saveItem;
   private JMenuItem asLabelsItem;
   private JMenuItem helpItem;
   private JMenuItem aboutItem;
   private JMenuItem exitItem;
   private JTextField txtFltr = new JTextField(5) ;
   JCheckBox colBox[] = new JCheckBox[n_cols];
   JButton go, go2 = new JButton("Save");
   JButton close, close2 = new JButton("Cancel") ;
   JDialog jd, jd2;
   JTextField enteredText[] = new JTextField[n_cols];
   String cTitles[] = { " Organization ", " Last ", " First ",
                         " Home ", " Work ", " Cell ", " Fax ", 
                         " Street ", " City ", " State ", " Zip ",  " Email ",
			 " Memo " };

   boolean columnSelected[] = new boolean[n_cols];
   private JTextComponent txtFld[] = new JTextComponent[n_txtBoxes];
   private boolean        txtFldChanged[] = { false, false, false, false, false } ;
   DocumentListener       filterListener = new FilterListener();
   KeyListener            txtFldKeyListener = new TextFieldKeyListener();

   public Addressbook() {
      addWindowListener(new WindowAdapter() {
	public void windowClosing(WindowEvent e) { 
	    saveTextFieldChanges( curTblRow ); dispose(); System.exit(0);
      } } ); 

      c = getContentPane();
      sorter = new TableRowSorter<AddressTableModel>( addrTMDL );
      tbl = new JTable( addrTMDL );
      tbl.setRowSorter( sorter );
      txtFltr.getDocument().addDocumentListener( filterListener );
      
      scrollPane = new JScrollPane(tbl); // No scrollpane, no column titles will be displayed.
      scrollPane.setPreferredSize( new Dimension( w_width, w_height) );
      // JTableHeader header = tbl.getTableHeader();
      // header.addMouseListener( addrTMDL.new ColumnListener( tbl ) );

      for ( int i = 0; i < txtFld.length; i ++ ) {
	  txtFld[i] = i < txtFld.length - 1 ? new JTextField ( i < 2 ? 15 : 4) : new JTextArea(6, 40);
     	      txtFld[i].addKeyListener ( txtFldKeyListener );
      } 

      // make a menubar and add to the pane
      JMenuBar mbar = createMenuBar(); setJMenuBar( mbar );

      // c.add( new JButton( new ImageIcon( "picture.gif" ) ), BorderLayout.NORTH );
      c.add(scrollPane, BorderLayout./*SOUTH*/CENTER);
      
      // Layout text components and associated labels.
      JPanel pnText = new JPanel();
      setTxtCmdPanel( pnText );

      c.add( pnText, BorderLayout./*CENTER*/NORTH);

      // List selection listener to get selected curTblRow and display its memo field
      // when a row of the table is selected.
      ListSelectionModel rowSM = tbl.getSelectionModel();
      rowSM.addListSelectionListener( new ListSelectionListener() {
         public void valueChanged( ListSelectionEvent e ) {
	    saveTextFieldChanges( curTblRow );
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if( lsm.isSelectionEmpty() ) { }
            else {
	       curTblRow = tbl.getSelectedRow();
	       modelToTextField ( curTblRow, false );
               }
	       lbName.setText(
		  addrTMDL.getValueAt(mdlRow, 1) + ", " + 
		  addrTMDL.getValueAt(mdlRow, 2)
		  ); 
	    }
	  } );

      // Some columns are displayed in text boxes those columns will not displayed in table.
      // The section hiding those columns  by removing them from table columns. Those columns
      // are still in table's model so that the data will be come back and forth from text
      // boxes and data collection in table model. 
      for (int i = street_start + 1 ; i <= n_cols + 1 ; i ++ ) {
	 TableColumn col = null;
	 if ( i != 12 ) {
	     col = tbl.getColumnModel().getColumn(i-1);
	     col.setMinWidth(0); col.setMaxWidth(0); col.setPreferredWidth(0);
	 }
      } 
      reloadAndReset( false ); 
      // setResizable(false);
      pack();
      setSize(w_width, w_height);
      setVisible( true );
      if ( tbl != null && tbl.getRowCount() > 0 ) tbl.setRowSelectionInterval(0, 0);
      go2.addActionListener( this );
      close2.addActionListener( this );
      for ( int i = 0; i < n_cols ; i ++ ) enteredText[i] = new JTextField(10);
   }
 
   public void paint(Graphics g) {
      super.paint(g);
   }
 
   public static void main(String args[]) {
      Addressbook address = new Addressbook();

   }

// -------------- MENU BAR  ----------------------------------
   private JMenuBar createMenuBar() {
// sets up the menu bar
      JMenuBar mbar = new JMenuBar();
//--------------------- SAVE MENU -------------------------------
      JMenu saveMenu = new JMenu( "Save" );
      saveMenu.setMnemonic( 'S' );

      saveItem = new JMenuItem( "Save selected fields", 'f' );
      saveItem.addActionListener( this );
      saveMenu.add( saveItem );

      asLabelsItem = new JMenuItem( "Save as labels", 'l' );
      asLabelsItem.addActionListener( this );
      saveMenu.add( asLabelsItem );

      saveMenu.addSeparator();

      exitItem = new JMenuItem( "Exit", 'X' );
      exitItem.addActionListener( this );
      saveMenu.add( exitItem );

      mbar.add( saveMenu );
//---------------------------- FILE MENU ---------------------------------
      JMenu fileMenu = new JMenu( "File" );
      fileMenu.setMnemonic( 'F' );

      openItem = new JMenuItem( "Open file", 'O' );
      openItem.addActionListener( this );
      fileMenu.add( openItem );

      mbar.add( fileMenu );
//-------------------------- HELP MENU --------------------------------
      JMenu helpMenu = new JMenu( "Help" );
      helpMenu.setMnemonic( 'H' );
      helpItem = new JMenuItem( "Help", 'H' );
      helpMenu.add( helpItem );
      helpItem.addActionListener( this );
      aboutItem = new JMenuItem( "About ...", 'A' );
      helpMenu.add( aboutItem );
      aboutItem.addActionListener( this );
      mbar.add( helpMenu );

      return mbar;
   }
// --------- subpanel for text fields -- GridBagLayout --------------------
   private void setTxtCmdPanel( JPanel pnTxtAndCmd ) {

      GridBagLayout gb_txtFld = new GridBagLayout();
      JPanel pnText = new JPanel( gb_txtFld);

      GridBagLayout gb_memo = new GridBagLayout();
      JPanel pn_memo = new JPanel( gb_memo );

      gbConstraints.gridx = gbConstraints.gridy = 0;
      for (int i = 0; i < n_txtBoxes - 1; i ++ ) {
	  gbConstraints.gridx = 0; gbConstraints.gridy = i ;
          gbConstraints.anchor = GridBagConstraints.EAST ;
          pnText.add( new JLabel(cTitles[i + street_start]) , gbConstraints );
	  // gbConstraints.fill = GridBagConstraints.HORIZONTAL;
          gbConstraints.anchor = GridBagConstraints.WEST;
	  gbConstraints.gridx = 1;
          pnText.add( txtFld[i], gbConstraints );
      }

      gbConstraints.anchor = GridBagConstraints.EAST;
      pnText.add( new JLabel("Memo" ) , gbConstraints );

      gbConstraints.gridx = 1; gbConstraints.gridy = 2 ;
      gbConstraints.anchor = GridBagConstraints.EAST;
      pnText.add( lbName, gbConstraints);
	      
       
      pnTxtAndCmd.add( pnText, BorderLayout.EAST);

      gbConstraints.fill = GridBagConstraints.BOTH;
      pn_memo.add( new JScrollPane(txtFld[n_txtBoxes - 1]) , gbConstraints);
      pnTxtAndCmd.add( pn_memo, BorderLayout.CENTER );

      // Add 4 command buttons and filer in panel.
      GridBagLayout gb_cmd = new GridBagLayout();
      JPanel pnCommand = new JPanel( gb_cmd );

      JButton btn[] 	= { btnAdd, btnDelete, btnReload, btnSave };
      String  btnTips[] = { "Add new contact info.", "Delete a contact info.",
	                                     "Reload contacts from database", "Save updates in batch" };

      // Email lab. and text plus 4 buttons to panel managed by Grid Bag gbConstraints.
      gbConstraints.insets = new Insets(1, 1, 1, 1);
      gbConstraints.gridx = gbConstraints.gridy = 0;
      for ( int i = 0; i < 4; i++ ) {
	   gbConstraints.gridx = i % 2; gbConstraints.gridy = i / 2 ; 
           gbConstraints.fill = GridBagConstraints.HORIZONTAL;
	   btn[i].addActionListener(this); btn[i].setToolTipText( btnTips[i]);
	   pnCommand.add( btn[i], gbConstraints );
      }

      gbConstraints.anchor = GridBagConstraints.EAST ;
      gbConstraints.gridx = 0; gbConstraints.gridy = 2;
      pnCommand.add( new JLabel("Filter"), gbConstraints);
      gbConstraints.gridx = 1; 
      pnCommand.add( txtFltr, gbConstraints);
      txtFltr.addActionListener( this );

      pnTxtAndCmd.add( pnCommand, BorderLayout.EAST );
   }

// ------------------------- ACTION LISTENERS --------------------------------
   public void actionPerformed(ActionEvent e) {
      Object o = e.getSource();

      if ( o.equals( openItem ) ) {
         // to open a view of a text file
         TextView viewer = new TextView( "Text Viewer" );
         return;
      }
      if ( o.equals( saveItem ) ) {
         // to save selected columns of data to text file
         jd = new JDialog( this, "Column Selection" );
         jd.getContentPane().setLayout( new GridLayout( 16, 1 ) );

         JLabel note = new JLabel( "Select columns to save:" );
         jd.getContentPane().add( note );
         for( int i = 0; i < n_cols; i++ ) {
            colBox[i] = new JCheckBox( cTitles[i] );
            colBox[i].addItemListener( this );
            jd.getContentPane().add( colBox[i] );
         }
         go = new JButton( "Save data" );
         go.addActionListener( this );
         jd.getContentPane().add( go );
         close = new JButton( "Close" );
         close.addActionListener( this );
         jd.getContentPane().add( close );

         jd.setSize( 400, 400 );
         jd.setVisible(true );
         return;
      }

      if( o.equals( go ) ) {
         // a button on the saveItem window to make it happen
         addrTMDL.makeTextFile( columnSelected );
         return;
      }
      if( o.equals( close ) ) {
         // a button on the saveItem window to close it
         jd.dispose();
         return;
      }
      if ( o.equals( asLabelsItem ) ) {
         // option to make a text file formatted as address labels
         addrTMDL.makeLabelFile();
         return;
      }
      if (o.equals( helpItem ) ) {        // help menu
         String msg;
         msg = " 1. Click on column title to sort by that column." +
               " Click again to reverse sort order.\n" +
               " 2. To filter list, type filter string and enter.\n" +
               "                 ";

         JOptionPane.showMessageDialog(null, msg, "Help",
         JOptionPane.INFORMATION_MESSAGE);
         return;
      }
      if (o.equals( aboutItem ) ) {                   // about this program
         String msg;
         msg = "        Address book Program Built on\n"  +
               "      Java GUI and Oracle Database 10.g\n"  +
               " with TableModel linking database table to JTable Data,\n" +
	       "   and batch updating may be implemented later." ;

         JOptionPane.showMessageDialog(null, msg, "About", JOptionPane.INFORMATION_MESSAGE);
         return;
      }
      if (o.equals( exitItem ) ) System.exit( 0 );

      if( o.equals( btnAdd ) ) {
	 addNewContact();
	 return;
      }

      if( o.equals( go2 ) ) {
         // this button goes with the add item option to make it happen
         String values[] = new String[n_cols + 1];
         for( int i = 0; i < n_cols ; i++ )
	     values[i] = enteredText[i].getText() == null ? "" : enteredText[i].getText();

	 values[n_cols] = String.format("%d", addrTMDL.nextAddressID());

         try { addrTMDL.addRow( values ); }
	 catch (Exception ego2) { }
         close( jd2 );
	 reloadAndReset( true );
         return;
      }
      if( o.equals( close2 ) ) {
         // this button goes with the add item option to close that window
         close( jd2 ); 
         return;
      }
      if( o.equals( btnDelete ) ) {
         curTblRow = tbl.getSelectedRow();
	 if ( curTblRow == -1 ) {
	     JOptionPane.showMessageDialog(this, "Select a row, and then click <Delete>!", "No Row Selected", JOptionPane.INFORMATION_MESSAGE);
	     return;
	 }
	 int key = Integer.parseInt(tbl.getValueAt(curTblRow , n_cols).toString() );
	 int choice = GUIUtil.yesNoConfirm (this, "Deletion Confirmation",  ("Delete <" + 
		     tbl.getValueAt(curTblRow , 1) + ", " + tbl.getValueAt(curTblRow , 2) + ", " + key + "> ?"));
	
	 if  (choice == JOptionPane.NO_OPTION) return;
	 addrTMDL.removeRowBy( key ) ;
	 reloadAndReset( true );
         return;
      }
      if( o.equals( btnSave ) ) {
         // this is the Save Changes button
         System.out.println( "Save Changes button was pressed." );
         JOptionPane.showMessageDialog( null,
            "Batch changes not implemented. Changes are done as they happen." ,
            "Save Changes Message", JOptionPane.INFORMATION_MESSAGE );
	 jd2.dispose();
         return;
      }
      if( o.equals( btnReload ) ) {
         // this is the Reload button to reload data from database
         reloadAndReset( true ); 
         return;
      }
   }

   public void itemStateChanged(ItemEvent e) {
// this watches checkboxes to see if they are checked or unchecked
      int columnID = 0;
      Object source = e.getItemSelectable();
      for( int i = 0; i < n_cols; i++ )
         if (source == colBox[i] ) {
            columnID = i;
         }
      if (e.getStateChange() == ItemEvent.DESELECTED) {
            // was deselected
         columnSelected[ columnID ] = false;
      } else {
         // was selected
         columnSelected[ columnID ] = true;
      }

   }

   private void reloadAndReset( boolean reld ) {
     if ( reld ) {
	   addrTMDL.reload ();
           // if ( tbl != null && tbl.getRowCount() > 0 ) tbl.setRowSelectionInterval(0, 0);
     }
     setTitle(addrTMDL.getRowCount() + " records in Addressbook" + 
	          ( ( txtFltr.getText() == null || txtFltr.getText() == "" ) ? "" :
		     (" and " + tbl.getRowCount() + " Selected" ) )
	     );
   }

   private void close( JDialog dialog ) {
       dialog.setVisible( false );
       dialog.dispose();
   }

    private void addNewContact () {
      GridBagLayout      gbLayout = new GridBagLayout();

      // gbConstraints.insets = new Insets(0,0,0,0);
      // Creates a new Dialog box for entering data. 
      jd2 = new JDialog( this, "New Contact Info" );
      Container c = jd2.getContentPane();
      c.setLayout( gbLayout );
      for( int i = 0; i < n_cols ; i++ ) {
	 gbConstraints.gridy = i ; gbConstraints.gridx = 0;
         gbConstraints.anchor = GridBagConstraints.EAST ;
         c.add( new JLabel(cTitles[i]) , gbConstraints );

	 gbConstraints.gridy = i; gbConstraints.gridx = 1;
         gbConstraints.anchor = GridBagConstraints.WEST;
         c.add( enteredText[i], gbConstraints );
      }
      
      enteredText[1].setText("Doe");
      enteredText[2].setText("John");
      enteredText[street_start+1].setText("Bakersfield");
      enteredText[street_start+2].setText("CA");
      enteredText[street_start+3].setText("93311");

      gbConstraints.gridy = n_cols ;
      gbConstraints.gridx = 0; c.add( go2, gbConstraints );
      gbConstraints.gridx = 1; c.add( close2, gbConstraints);

      jd2.setSize( 300, 450);
      jd2.setVisible( true );
      return;
   }

   private void saveTextFieldChanges ( int tblCurrentRow ) {
      boolean changed = false;
      for ( int i = 0; i < txtFldChanged.length; i ++ ) changed = changed || txtFldChanged[i];
      if ( ! changed ) return;

      int res = GUIUtil.yesNoConfirm( this, "Save Change", "One or more columns have been changed.\nSave the changes?");

      if ( res == JOptionPane.YES_OPTION )
	    textFieldToModel( tblCurrentRow);
      else  modelToTextField( tblCurrentRow, true );
   }

   private void textFieldToModel( int tblCurrentRow ) {
   // private void textFieldToModel( int tblCurrrentRow, String str, int tCol ) {
      mdlRow = tbl.convertRowIndexToModel( tblCurrentRow );
      for ( int i = 0; i < n_txtBoxes; i++ ) {
	 if ( txtFldChanged[i] ) {
	    // textFieldToModel(txtFld[i].getText(), (i < n_txtBoxes - 1 ? i : n_txtBoxes) + street_start );
	    addrTMDL.setValueAt (txtFld[i].getText(), mdlRow, (i < n_txtBoxes - 1 ? i : n_txtBoxes) + street_start );
	    txtFldChanged[i] = false;
	 }
      }
      return; 
   }

   private void modelToTextField ( int tbCurrentRow, boolean check ) {
	mdlRow = tbl.convertRowIndexToModel( tbCurrentRow );
	Object value = null;
        for( int i = 0; i < n_txtBoxes ; i++ ) {
	   // When row selection is changed, all textbox-associated columns must be filled with column data.
	   if ( !check || txtFldChanged[i] ) {
	      mdlCol = i < n_txtBoxes - 1 ? i + street_start : n_cols - 1 ;
	      value = addrTMDL.getValueAt( mdlRow, mdlCol );
	      txtFld[i].setText( value == null ? "" : value.toString() );
	      txtFldChanged[i] = false;
	   }
   	}
   }

   private void refiltering() {
      RowFilter<AddressTableModel, Object>  rf = null;
      // If current text doesn't parse, ignore it.
      try {
         // Filter on column 0, 1 and 2.
         rf = RowFilter.regexFilter( txtFltr.getText(), 1, 2 ) ;
     } catch (java.util.regex.PatternSyntaxException erf) {
          txtFltr.setText("");
	  return;
     }
     sorter.setRowFilter( rf );
     reloadAndReset( false );
     return;
   }

   private class FilterListener implements DocumentListener {

       public void changedUpdate (DocumentEvent e ) {
	   refiltering();
       }

       public void insertUpdate (DocumentEvent e ) {
	   refiltering();
       }

       public void removeUpdate (DocumentEvent e ) {
	   refiltering(); 
       }
   }

   private class TextFieldKeyListener implements KeyListener {

       public void keyPressed ( KeyEvent e ) {
       }

       public void keyReleased( KeyEvent e ) {
       }

       public void keyTyped( KeyEvent e ) {
	   Object src = e.getSource ();

	   for ( int i = 0; i < n_txtBoxes; i++ )
	       if ( src == txtFld[i] ) txtFldChanged[i] = true;
       }
   }
}

