/** Table Model based on JDBC  2.0 :
    An JTable model is defined for a SQL statement.
*/
 
import java.sql.*;
import javax.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.io.*;
import java.util.*;
 
public class AddressTableModel extends AbstractTableModel {

    public static final long serialVersionUID = 87823232;

    String cTitles[] = { "Organization", "Last", "First",
                         "Home", "Work", "Cell", "Fax",
                         "Street", "City", "State", "Zip", "Email", "Memo", "ID" };
    AddressTableModel() {
        String  url = "jdbc:oracle:thin:@delphi.cs.csubak.edu:1521:dbs01",
                user="hotel", passwd="c3m4p2s";
        try {
                DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
                cnn = DriverManager.getConnection(url, user, passwd);
                cnn.setAutoCommit(true);
                stmt = cnn.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_UPDATABLE);
                getResultSet(sql);
        } catch (SQLException e ) { e.printStackTrace(); System.exit(-1); }
    }
 
    void getResultSet( String sql ) {
        try {
                resultSet = stmt.executeQuery(sql);
                getColumnTitles();
                resultSet.last();
                recordCount = resultSet.getRow();
                resultSet.first();
        } catch (SQLException e ) { e.printStackTrace(); }
    }

    void reload() {
         getResultSet(sql);
         currentRow = 0;
         fireTableDataChanged();
    }

    void getColumnTitles() {
        try {
                ResultSetMetaData meta = resultSet.getMetaData();
                columnCount = meta.getColumnCount();
                columnTitles = new Vector<String> (columnCount);
                for ( int i = 1; i <= columnCount; i ++ )
                        columnTitles.add( ScreenIO.expandString(meta.getColumnName(i), 15) );
        } catch( SQLException e) { e.printStackTrace(); }
    }
 
    public boolean isCellEditable(int row, int col) { return true; }
    public int getRowCount()    { return recordCount; }
    public int getColumnCount() { return 14; } 
    public String getColumnName(int col) { return cTitles[col]; }
 
    public Object getValueAt(int row, int col) {
        try {
                resultSet.relative (row - currentRow);
		currentRow = row;
                return resultSet.getString(col+1) ;
        } catch ( SQLException e ) { /*e.printStackTrace() ;*/ }
        return " ";
    }
   public String resultRowToString( int row ) {
      String tmp = "";
      try {
         resultSet.relative (row - currentRow); currentRow = row;
         for( int i = 1; i <= columnCount; i++ ) {
            tmp = tmp + resultSet.getString( i );
         }
      } catch ( SQLException e ) { e.printStackTrace() ; }
      return tmp;
   }
   public void makeTextFile( boolean colSelected[] ) {
      currentRow = FileIO.makeTextFile( resultSet, currentRow, recordCount, colSelected );
      return;
   }
   public void makeLabelFile() {
      currentRow =FileIO.makeLabelFile( resultSet, currentRow, recordCount );
      return;
   }
   public void  setValueAt( Object obj, int row, int col ) {
      try {
         resultSet.relative (row - currentRow); currentRow = row;
         resultSet.updateString(col+1, (String) obj);
         resultSet.updateRow();
         cnn.commit();
      } catch (SQLException e) { e.printStackTrace(); }
   }
 
   public void addRow( String[] newValues ) {
      try {
         resultSet.moveToInsertRow();
         for( int i = 0; i < newValues.length; i++ )
            resultSet.updateString( i+1, newValues[i] );
         resultSet.insertRow();
         fireTableDataChanged();
      } catch (SQLException e) { e.printStackTrace(); }
   }

   // The parameter is the model row, correcsponding to row in the current display of table. 
   public Object removeRow( int row ) {
      try {
         resultSet.absolute (row +1);  // currentRow = row;
         resultSet.deleteRow();
         // currentRow = 0;
         recordCount--;
         // getResultSet(sql);
         // fireTableDataChanged();
      } catch (SQLException e ) { e.printStackTrace() ; }
      return "Hello";
    }
    public void saveData() {
        try { cnn.commit(); } catch (SQLException e) { e.printStackTrace(); }
    }
 
    public void requery(String name) {
        String tmp = sql + " WHERE lastName like '" + name + "%' OR firstName like '" + name + "%'" ;
        System.out.println(tmp);
        getResultSet(tmp);
        fireTableDataChanged();
        // currentRow = 0;
    }

    public void removeRowBy ( int key ) {
	try { 	
	    cstmt = cnn.prepareCall( "{ call removeAddressBy (?) }");
	    cstmt.setInt(1, key);
            cstmt.executeUpdate();
	    reload( );
	} catch (SQLException e) { }
    }
    public int nextAddressID () {
	try { 	
	    cstmt = cnn.prepareCall( "{? = call nextAddressID}");
	    cstmt.registerOutParameter(1, java.sql.Types.INTEGER);
            cstmt.executeQuery();
	    int n = cstmt.getInt(1);
	    return n;
	} catch (SQLException e) { return -1 ; }
    }

    // Data members
    String sql = "SELECT Organization, LastName Last, FirstName First, HomePhone Home, " +
	         " WorkPhone Work, CellPhone Cell, Fax, Street, City, State, Zip, Email, Memo, ID " +
		 " FROM Address";
    Connection  	cnn;
    Statement   	stmt;
    CallableStatement   cstmt;
    ResultSet   	resultSet;
    Vector<String>      columnTitles;
    int currentRow = 0, columnCount = 0, recordCount = 0;
    boolean sortAsc = true;
    File file = null;
}

